<div x-data="{ employeeId: <?php if ((object) ('employee_id') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('employee_id'->value()); ?>')<?php echo e('employee_id'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('employee_id'); ?>')<?php endif; ?>.live }"
     x-init="if (employeeId) { $wire.manageDocuments(employeeId); }">
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Employees')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">

                    <div class="flex justify-between mb-4">
                        <div class="flex items-center">
                            <label for="filterStatus" class="mr-2 text-sm font-medium text-gray-700"><?php echo e(__('Show:')); ?></label>
                            <select wire:model.live="filterStatus" id="filterStatus" class="block w-full rounded-md border-gray-300 shadow-sm text-sm">
                                <option value="active"><?php echo e(__('Active')); ?></option>
                                <option value="trashed"><?php echo e(__('Deleted')); ?></option>
                                <option value="all"><?php echo e(__('All')); ?></option>
                            </select>
                        </div>
                        <div class="w-auto">
                            <button wire:click="create" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded" aria-label="<?php echo e(__('Create Employee')); ?>">
                                <i class="fa-solid fa-plus"></i>
                            </button>
                        </div>
                    </div>

                    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
                        <table class="w-full text-sm text-left text-gray-500">
                            <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                                <tr>
                                    <th scope="col" class="px-6 py-3"><?php echo e(__('Name')); ?></th>
                                    <th scope="col" class="px-6 py-3"><?php echo e(__('Email')); ?></th>
                                    <th scope="col" class="px-6 py-3"><?php echo e(__('Employee Type')); ?></th>
                                    <th scope="col" class="px-6 py-3"><?php echo e(__('Status')); ?></th>
                                    <th scope="col" class="px-6 py-3"><span class="sr-only"><?php echo e(__('Actions')); ?></span></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr wire:key="<?php echo e($employee->id); ?>" class="bg-white border-b hover:bg-gray-50 <?php echo e($employee->trashed() ? 'bg-red-50/50' : ''); ?>">
                                        <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                                            <?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?>

                                        </th>
                                        <td class="px-6 py-4"><?php echo e($employee->email); ?></td>
                                        <td class="px-6 py-4"><?php echo e($employee->employee_type); ?></td>
                                        <td class="px-6 py-4">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($employee->status === 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                                                <?php echo e($employee->status); ?>

                                            </span>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($employee->trashed()): ?>
                                                <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-200 text-gray-800">
                                                    <?php echo e(__('Deleted')); ?>

                                                </span>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </td>
                                        <td class="px-6 py-4 text-right">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($employee->trashed()): ?>
                                                <button wire:click="restore(<?php echo e($employee->id); ?>)" wire:confirm="<?php echo e(__('Are you sure you want to restore this employee?')); ?>" class="bg-green-500 hover:bg-green-700 text-white font-bold py-1 px-3 rounded" aria-label="<?php echo e(__('Restore')); ?>"><i class="fa-solid fa-undo"></i></button>
                                                <button wire:click="forceDelete(<?php echo e($employee->id); ?>)" wire:confirm="<?php echo e(__('Are you sure you want to permanently delete this employee? This action cannot be undone.')); ?>" class="bg-red-700 hover:bg-red-900 text-white font-bold py-1 px-3 rounded ml-2" aria-label="<?php echo e(__('Force Delete')); ?>"><i class="fa-solid fa-times-circle"></i></button>
                                            <?php else: ?>
                                                <button wire:click="manageDocuments(<?php echo e($employee->id); ?>)" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-1 px-3 rounded" aria-label="<?php echo e(__('Manage Documents')); ?>"><i class="fa-solid fa-folder-open"></i></button>
                                                <button wire:click="edit(<?php echo e($employee->id); ?>)" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-1 px-3 rounded ml-2" aria-label="<?php echo e(__('Edit')); ?>"><i class="fa-solid fa-edit"></i></button>
                                                <button wire:click="delete(<?php echo e($employee->id); ?>)" wire:confirm="<?php echo e(__('Are you sure you want to delete this employee?')); ?>" class="bg-red-500 hover:bg-red-700 text-white font-bold py-1 px-3 rounded ml-2" aria-label="<?php echo e(__('Delete')); ?>"><i class="fa-solid fa-trash"></i></button>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr class="bg-white border-b">
                                        <td colspan="5" class="px-6 py-4 text-center text-gray-500">
                                            <?php echo e(__('No employees found.')); ?>

                                        </td>
                                    </tr>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        <?php echo e($employees->links()); ?>

                    </div>

                    <!-- Create/Edit Employee Modal -->
                    <div
                        x-data="{ show: false }"
                        x-cloak
                        x-on:open-modal.window="show = true"
                        x-on:close-modal.window="show = false"
                        x-on:keydown.escape.window="show = false"
                        x-show="show"
                        class="fixed inset-0 overflow-y-auto px-4 py-6 sm:px-0 z-50"
                    >
                        <div
                            x-show="show"
                            class="fixed inset-0 transform transition-all"
                            x-on:click="$dispatch('close-modal')"
                            x-transition:enter="ease-out duration-300"
                            x-transition:enter-start="opacity-0"
                            x-transition:enter-end="opacity-100"
                            x-transition:leave="ease-in duration-200"
                            x-transition:leave-start="opacity-100"
                            x-transition:leave-end="opacity-0"
                        >
                            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
                        </div>

                        <div
                            x-show="show"
                            class="mb-6 bg-white rounded-lg overflow-hidden shadow-xl transform transition-all sm:w-full sm:max-w-2xl sm:mx-auto"
                            x-transition:enter="ease-out duration-300"
                            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                            x-transition:leave="ease-in duration-200"
                            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                        >
                            <form wire:submit.prevent="save" wire:key="employee-form-<?php echo e($isEditing ? $form->employee->id : 'new'); ?>">
                                <div class="px-6 py-4">
                                    <div class="text-lg">
                                        <?php echo e($isEditing ? __('Edit Employee') : __('Create Employee')); ?>

                                    </div>

                                    <div class="mt-4 space-y-4">
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            <div>
                                                <label for="first_name" class="block text-sm font-medium text-gray-700"><?php echo e(__('First Name')); ?></label>
                                                <input wire:model.defer="form.first_name" id="first_name" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['form.first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                            <div>
                                                <label for="last_name" class="block text-sm font-medium text-gray-700"><?php echo e(__('Last Name')); ?></label>
                                                <input wire:model.defer="form.last_name" id="last_name" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['form.last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                        </div>
                                        <div>
                                            <label for="email" class="block text-sm font-medium text-gray-700"><?php echo e(__('Email')); ?></label>
                                            <input wire:model.defer="form.email" id="email" type="email" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['form.email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                        <div>
                                            <label for="document_number" class="block text-sm font-medium text-gray-700"><?php echo e(__('Document Number')); ?></label>
                                            <input wire:model.defer="form.document_number" id="document_number" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['form.document_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                            <div>
                                                <label for="employee_type" class="block text-sm font-medium text-gray-700"><?php echo e(__('Employee Type')); ?></label>
                                                <select wire:model.defer="form.employee_type" id="employee_type" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                                    <option value="driver"><?php echo e(__('Driver')); ?></option>
                                                    <option value="administrative"><?php echo e(__('Administrative')); ?></option>
                                                </select>
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['form.employee_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                            <div>
                                                <label for="status" class="block text-sm font-medium text-gray-700"><?php echo e(__('Status')); ?></label>
                                                <select wire:model.defer="form.status" id="status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                                    <option value="active"><?php echo e(__('Active')); ?></option>
                                                    <option value="on_leave"><?php echo e(__('On Leave')); ?></option>
                                                    <option value="terminated"><?php echo e(__('Terminated')); ?></option>
                                                </select>
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['form.status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                        </div>
                                        <div>
                                            <label for="hire_date" class="block text-sm font-medium text-gray-700"><?php echo e(__('Hire Date')); ?></label>
                                            <input wire:model.defer="form.hire_date" id="hire_date" type="date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['form.hire_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </div>
                                    </div>

                                    <div class="bg-gray-100 px-6 py-4 flex justify-end">
                                        <button type="button" x-on:click="show = false" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded mr-2">
                                            <?php echo e(__('Cancel')); ?>

                                        </button>
                                        <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                                            <?php echo e(__('Save')); ?>

                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
    <!-- Document Management Modal -->
    <div
        x-data="{ show: false }"
        x-cloak
        x-on:open-document-form-modal.window="show = true"
        x-on:close-document-form-modal.window="show = false"
        x-on:keydown.escape.window="show = false"
        x-show="show"
        class="fixed inset-0 overflow-y-auto px-4 py-6 sm:px-0 z-50"
    >
        <div
            x-show="show"
            class="fixed inset-0 transform transition-all"
            x-on:click="show = false"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
        >
            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
        </div>

        <div
            x-show="show"
            class="mb-6 bg-white rounded-lg overflow-hidden shadow-xl transform transition-all sm:w-full sm:max-w-3xl sm:mx-auto"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-4 sm:scale-95"
        >
            <form wire:submit.prevent="saveDocument" wire:key="document-form-<?php echo e($documentForm->document && $documentForm->document->exists ? $documentForm->document->id : 'new'); ?>">
                <div class="px-6 py-4">
                    <div class="text-lg">
                        <?php echo e($documentForm->document && $documentForm->document->exists ? __('Edit Document') : __('Create Document')); ?>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->currentEmployee): ?>
                            (<?php echo e(__('for')); ?> <?php echo e($this->currentEmployee->first_name); ?> <?php echo e($this->currentEmployee->last_name); ?>)
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <div class="mt-4 space-y-4">
                        <div>
                            <label for="document_name" class="block text-sm font-medium text-gray-700"><?php echo e(__('Document Name')); ?></label>
                            <input wire:model.defer="documentForm.name" id="document_name" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['documentForm.name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <div>
                            <label for="document_description" class="block text-sm font-medium text-gray-700"><?php echo e(__('Description')); ?></label>
                            <textarea wire:model.defer="documentForm.description" id="document_description" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></textarea>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['documentForm.description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <div>
                            <label for="document_file" class="block text-sm font-medium text-gray-700"><?php echo e(__('File')); ?></label>
                            <input wire:model="documentForm.file" id="document_file" type="file" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['documentForm.file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($documentForm->file_path && !$documentForm->file): ?>
                                <p class="text-sm text-gray-500 mt-1"><?php echo e(__('Current file:')); ?> <a href="<?php echo e(Storage::url($documentForm->file_path)); ?>" target="_blank" class="text-blue-600 hover:underline"><?php echo e(basename($documentForm->file_path)); ?></a></p>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <div>
                            <label for="document_url" class="block text-sm font-medium text-gray-700"><?php echo e(__('Or URL')); ?></label>
                            <input wire:model.defer="documentForm.file_path" id="document_url" type="url" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" placeholder="https://example.com/document.pdf">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['documentForm.file_path'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="document_issue_date" class="block text-sm font-medium text-gray-700"><?php echo e(__('Issue Date')); ?></label>
                                <input wire:model.defer="documentForm.issue_date" id="document_issue_date" type="date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['documentForm.issue_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            <div>
                                <label for="document_expiry_date" class="block text-sm font-medium text-gray-700"><?php echo e(__('Expiry Date')); ?></label>
                                <input wire:model.defer="documentForm.expiry_date" id="document_expiry_date" type="date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['documentForm.expiry_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                        <div>
                            <label for="document_status" class="block text-sm font-medium text-gray-700"><?php echo e(__('Status')); ?></label>
                            <select wire:model.defer="documentForm.status" id="document_status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                <option value="valid"><?php echo e(__('Valid')); ?></option>
                                <option value="expired"><?php echo e(__('Expired')); ?></option>
                                <option value="pending_review"><?php echo e(__('Pending Review')); ?></option>
                            </select>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['documentForm.status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="bg-gray-100 px-6 py-4 flex justify-end">
                    <button type="button"                             x-on:click="$dispatch('close-modal')" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded mr-2">
                        <?php echo e(__('Cancel')); ?>

                    </button>
                    <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                        <?php echo e(__('Save Document')); ?>

                    </button>
                </div>
            </form>

            <div class="p-6 text-gray-900 border-t mt-4">
                <h3 class="text-lg font-medium text-gray-900 mb-4"><?php echo e(__('Employee Documents')); ?></h3>
                <div class="flex justify-end mb-4">
                    <button wire:click="createDocument" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                        <?php echo e(__('Add Document')); ?>

                    </button>
                </div>
                <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
                    <table class="w-full text-sm text-left text-gray-500">
                        <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3"><?php echo e(__('Document Name')); ?></th>
                                <th scope="col" class="px-6 py-3"><?php echo e(__('Issue Date')); ?></th>
                                <th scope="col" class="px-6 py-3"><?php echo e(__('Expiry Date')); ?></th>
                                <th scope="col" class="px-6 py-3"><?php echo e(__('Status')); ?></th>
                                <th scope="col" class="px-6 py-3"><span class="sr-only"><?php echo e(__('Actions')); ?></span></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $employeeDocuments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr wire:key="document-<?php echo e($document->id); ?>" class="bg-white border-b hover:bg-gray-50 <?php echo e($document->trashed() ? 'bg-red-50/50' : ''); ?>">
                                    <td class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                                        <a href="<?php echo e(Storage::url($document->file_path)); ?>" target="_blank" class="text-blue-600 hover:underline"><?php echo e($document->name); ?></a>
                                    </td>
                                    <td class="px-6 py-4"><?php echo e($document->issue_date?->format('Y-m-d')); ?></td>
                                    <td class="px-6 py-4 <?php echo e($document->expiry_date?->isPast() ? 'text-red-600 font-bold' : ''); ?>">
                                        <?php echo e($document->expiry_date?->format('Y-m-d')); ?>

                                    </td>
                                    <td class="px-6 py-4">
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($document->status === 'valid' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                                            <?php echo e($document->status); ?>

                                        </span>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($document->trashed()): ?>
                                            <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-200 text-gray-800">
                                                <?php echo e(__('Deleted')); ?>

                                            </span>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 text-right">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($document->trashed()): ?>
                                            <button wire:click="restoreDocument(<?php echo e($document->id); ?>)" wire:confirm="<?php echo e(__('Are you sure you want to restore this document?')); ?>" class="bg-green-500 hover:bg-green-700 text-white font-bold py-1 px-3 rounded"><?php echo e(__('Restore')); ?></button>
                                            <button wire:click="forceDeleteDocument(<?php echo e($document->id); ?>)" wire:confirm="<?php echo e(__('Are you sure you want to permanently delete this document? This action cannot be undone.')); ?>" class="bg-red-700 hover:bg-red-900 text-white font-bold py-1 px-3 rounded ml-2"><?php echo e(__('Force Delete')); ?></button>
                                        <?php else: ?>
                                            <button wire:click="editDocument(<?php echo e($document->id); ?>)" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-1 px-3 rounded"><?php echo e(__('Edit')); ?></button>
                                            <button wire:click="deleteDocument(<?php echo e($document->id); ?>)" wire:confirm="<?php echo e(__('Are you sure you want to delete this document?')); ?>" class="bg-red-500 hover:bg-red-700 text-white font-bold py-1 px-3 rounded ml-2"><?php echo e(__('Delete')); ?></button>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr class="bg-white border-b">
                                    <td colspan="5" class="px-6 py-4 text-center text-gray-500">
                                        <?php echo e(__('No documents found for this employee.')); ?>

                                    </td>
                                </tr>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH D:\Trabajo\Personal\tda-admin-app\resources\views/livewire/employee/index.blade.php ENDPATH**/ ?>