@use(Illuminate\Support\Number)
<div x-data="{ vehicleId: @entangle('vehicle_id').live }"
     x-init="if (vehicleId) { $wire.manageDocuments(vehicleId); }">
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Vehicles') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">

                    <div class="flex justify-between mb-4">
                        <div class="flex items-center">
                            <label for="filterStatus" class="mr-2 text-sm font-medium text-gray-700">Show:</label>
                            <select wire:model.live="filterStatus" id="filterStatus" class="block w-full rounded-md border-gray-300 shadow-sm text-sm">
                                <option value="active">Active</option>
                                <option value="trashed">Deleted</option>
                                <option value="all">All</option>
                            </select>
                        </div>
                        <button wire:click="create" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded" aria-label="{{ __('Create Vehicle') }}">
                            <i class="fa-solid fa-plus"></i>
                        </button>
                    </div>

                    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
                        <table class="w-full text-sm text-left text-gray-500">
                            <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                                <tr>
                                    <th scope="col" class="px-6 py-3">{{ __('Name') }}</th>
                                    <th scope="col" class="px-6 py-3">Plate Number</th>
                                    <th scope="col" class="px-6 py-3">Type</th>
                                    <th scope="col" class="px-6 py-3">Status</th>
                                    <th scope="col" class="px-6 py-3"><span class="sr-only">Actions</span></th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($vehicles as $vehicle)
                                    <tr wire:key="{{ $vehicle->id }}" class="bg-white border-b hover:bg-gray-50 {{ $vehicle->trashed() ? 'bg-red-50/50' : '' }}">
                                        <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                                            {{ $vehicle->name }}
                                        </th>
                                        <td class="px-6 py-4">{{ $vehicle->plate_number }}</td>
                                        <td class="px-6 py-4">{{ $vehicle->vehicleType->name }}</td>
                                        <td class="px-6 py-4">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $vehicle->status === 'operational' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                                {{ $vehicle->status }}
                                            </span>
                                            @if ($vehicle->trashed())
                                                <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-200 text-gray-800">
                                                    Deleted
                                                </span>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4 text-right">
                                            @if ($vehicle->trashed())
                                                <button wire:click="restore({{ $vehicle->id }})" wire:confirm="{{ __('Are you sure you want to restore this vehicle?') }}" class="bg-green-500 hover:bg-green-700 text-white font-bold py-1 px-3 rounded" aria-label="{{ __('Restore') }}"><i class="fa-solid fa-undo"></i></button>
                                                <button wire:click="forceDelete({{ $vehicle->id }})" wire:confirm="{{ __('Are you sure you want to permanently delete this vehicle? This action cannot be undone.') }}" class="bg-red-700 hover:bg-red-900 text-white font-bold py-1 px-3 rounded ml-2" aria-label="{{ __('Force Delete') }}"><i class="fa-solid fa-times-circle"></i></button>
                                            @else
                                                <button wire:click="manageDocuments({{ $vehicle->id }})" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-1 px-3 rounded" aria-label="{{ __('Manage Documents') }}"><i class="fa-solid fa-folder-open"></i></button>
                                                <button wire:click="manageMaintenance({{ $vehicle->id }})" class="bg-purple-500 hover:bg-purple-700 text-white font-bold py-1 px-3 rounded ml-2" aria-label="{{ __('Manage Maintenance') }}"><i class="fa-solid fa-wrench"></i></button>
                                                <button wire:click="edit({{ $vehicle->id }})" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-1 px-3 rounded ml-2" aria-label="{{ __('Edit') }}"><i class="fa-solid fa-edit"></i></button>
                                                <button wire:click="delete({{ $vehicle->id }})" wire:confirm="{{ __('Are you sure you want to delete this vehicle?') }}" class="bg-red-500 hover:bg-red-700 text-white font-bold py-1 px-3 rounded ml-2" aria-label="{{ __('Delete') }}"><i class="fa-solid fa-trash"></i></button>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr class="bg-white border-b">
                                        <td colspan="5" class="px-6 py-4 text-center text-gray-500">
                                            No vehicles found.
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $vehicles->links() }}
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- Create/Edit Modal -->
    <div
        x-data="{ show: false }"
        x-cloak
        x-on:open-modal.window="show = true"
        x-on:close-modal.window="show = false"
        x-on:keydown.escape.window="show = false"
        x-show="show"
        class="fixed inset-0 overflow-y-auto px-4 py-6 sm:px-0 z-50"
    >
        <div
            x-show="show"
            class="fixed inset-0 transform transition-all"
            x-on:click="show = false"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
        >
            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
        </div>

        <div
            x-show="show"
            class="mb-6 bg-white rounded-lg overflow-hidden shadow-xl transform transition-all sm:w-full sm:max-w-2xl sm:mx-auto"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
        >
            <form wire:submit.prevent="save" wire:key="vehicle-form-{{ $isEditing ? $form->vehicle->id : 'new' }}">
                <div class="px-6 py-4">
                    <div class="text-lg">
                        {{ $isEditing ? 'Edit Vehicle' : 'Create Vehicle' }}
                    </div>

                    <div class="mt-4 space-y-4">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700">Name</label>
                                <input wire:model.defer="form.name" id="name" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                @error('form.name') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                            <div>
                                <label for="plate_number" class="block text-sm font-medium text-gray-700">Plate Number</label>
                                <input wire:model.defer="form.plate_number" id="plate_number" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                @error('form.plate_number') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="brand" class="block text-sm font-medium text-gray-700">Brand</label>
                                <input wire:model.defer="form.brand" id="brand" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                @error('form.brand') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                            <div>
                                <label for="model" class="block text-sm font-medium text-gray-700">Model</label>
                                <input wire:model.defer="form.model" id="model" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                @error('form.model') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="year" class="block text-sm font-medium text-gray-700">Year</label>
                                <input wire:model.defer="form.year" id="year" type="number" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                @error('form.year') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                            <div>
                                <label for="vin" class="block text-sm font-medium text-gray-700">VIN</label>
                                <input wire:model.defer="form.vin" id="vin" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                @error('form.vin') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="vehicle_type_id" class="block text-sm font-medium text-gray-700">{{ __('Vehicle Type') }}</label>
                                <select wire:model.defer="form.vehicle_type_id" id="vehicle_type_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                    <option value="">{{ __('Select Type') }}</option>
                                    @foreach($vehicleTypes as $type)
                                        <option value="{{ $type->id }}">{{ $type->name }}</option>
                                    @endforeach
                                </select>
                                @error('form.vehicle_type_id') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                            <div>
                                <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
                                <select wire:model.defer="form.status" id="status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                    <option value="operational">Operational</option>
                                    <option value="in_maintenance">In Maintenance</option>
                                    <option value="out_of_service">Out of Service</option>
                                </select>
                                @error('form.status') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                    </div>

                    <div class="bg-gray-100 px-6 py-4 flex justify-end">
                        <button type="button" x-on:click="show = false" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded mr-2">
                            Cancel
                        </button>
                        <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                            Save
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Document Management Modal -->
    <div
        x-data="{ show: false }"
        x-cloak
        x-on:open-document-form-modal.window="show = true"
        x-on:close-document-form-modal.window="show = false"
        x-on:keydown.escape.window="show = false"
        x-show="show"
        class="fixed inset-0 overflow-y-auto px-4 py-6 sm:px-0 z-50"
    >
        <div
            x-show="show"
            class="fixed inset-0 transform transition-all"
            x-on:click="$dispatch('close-document-form-modal'); $wire.resetVehicleId()"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
        >
            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
        </div>

        <div
            x-show="show"
            class="mb-6 bg-white rounded-lg overflow-hidden shadow-xl transform transition-all sm:w-full sm:max-w-3xl sm:mx-auto"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-4 sm:scale-95"
        >
            <form wire:submit.prevent="saveDocument" wire:key="document-form-{{ $documentForm->document && $documentForm->document->exists ? $documentForm->document->id : 'new' }}">
                <div class="px-6 py-4">
                    <div class="text-lg">
                        {{ $documentForm->document && $documentForm->document->exists ? __('Edit Document') : __('Create Document') }}
                        @if ($this->currentVehicle)
                            ({{ __('for') }} {{ $this->currentVehicle->name }})
                        @endif
                    </div>

                    <div class="mt-4 space-y-4">
                        <div>
                            <label for="document_name" class="block text-sm font-medium text-gray-700">{{ __('Document Name') }}</label>
                            <input wire:model.defer="documentForm.name" id="document_name" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                            @error('documentForm.name') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label for="document_description" class="block text-sm font-medium text-gray-700">{{ __('Description') }}</label>
                            <textarea wire:model.defer="documentForm.description" id="document_description" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></textarea>
                            @error('documentForm.description') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label for="document_file" class="block text-sm font-medium text-gray-700">{{ __('File') }}</label>
                            <input wire:model="documentForm.file" id="document_file" type="file" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                            @error('documentForm.file') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            @if ($documentForm->file_path && !$documentForm->file)
                                <p class="text-sm text-gray-500 mt-1">{{ __('Current file:') }} <a href="{{ Storage::url($documentForm->file_path) }}" target="_blank" class="text-blue-600 hover:underline">{{ basename($documentForm->file_path) }}</a></p>
                            @endif
                        </div>
                        <div>
                            <label for="document_url" class="block text-sm font-medium text-gray-700">{{ __('Or URL') }}</label>
                            <input wire:model.defer="documentForm.file_path" id="document_url" type="url" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" placeholder="https://example.com/document.pdf">
                            @error('documentForm.file_path') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="document_issue_date" class="block text-sm font-medium text-gray-700">{{ __('Issue Date') }}</label>
                                <input wire:model.defer="documentForm.issue_date" id="document_issue_date" type="date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                @error('documentForm.issue_date') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                            <div>
                                <label for="document_expiry_date" class="block text-sm font-medium text-gray-700">{{ __('Expiry Date') }}</label>
                                <input wire:model.defer="documentForm.expiry_date" id="document_expiry_date" type="date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                @error('documentForm.expiry_date') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div>
                            <label for="document_status" class="block text-sm font-medium text-gray-700">{{ __('Status') }}</label>
                            <select wire:model.defer="documentForm.status" id="document_status" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                <option value="valid">{{ __('Valid') }}</option>
                                <option value="expired">{{ __('Expired') }}</option>
                                <option value="pending_review">{{ __('Pending Review') }}</option>
                            </select>
                            @error('documentForm.status') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                    </div>
                </div>

                <div class="bg-gray-100 px-6 py-4 flex justify-end">
                    <button type="button" x-on:click="$dispatch('close-document-form-modal'); $wire.resetVehicleId()" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded mr-2">
                        {{ __('Cancel') }}
                    </button>
                    <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                        {{ __('Save Document') }}
                    </button>
                </div>
            </form>

            <div class="p-6 text-gray-900 border-t mt-4">
                <h3 class="text-lg font-medium text-gray-900 mb-4">{{ __('Vehicle Documents') }}</h3>
                <div class="flex justify-end mb-4">
                    <button wire:click="createDocument" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                        {{ __('Add Document') }}
                    </button>
                </div>
                <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
                    <table class="w-full text-sm text-left text-gray-500">
                        <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3">{{ __('Document Name') }}</th>
                                <th scope="col" class="px-6 py-3">{{ __('Issue Date') }}</th>
                                <th scope="col" class="px-6 py-3">{{ __('Expiry Date') }}</th>
                                <th scope="col" class="px-6 py-3">{{ __('Status') }}</th>
                                <th scope="col" class="px-6 py-3"><span class="sr-only">{{ __('Actions') }}</span></th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($vehicleDocuments as $document)
                                <tr wire:key="document-{{ $document->id }}" class="bg-white border-b hover:bg-gray-50 {{ $document->trashed() ? 'bg-red-50/50' : '' }}">
                                    <td class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                                        <a href="{{ Storage::url($document->file_path) }}" target="_blank" class="text-blue-600 hover:underline">{{ $document->name }}</a>
                                    </td>
                                    <td class="px-6 py-4">{{ $document->issue_date?->format('Y-m-d') }}</td>
                                    <td class="px-6 py-4 {{ $document->expiry_date?->isPast() ? 'text-red-600 font-bold' : '' }}">
                                        {{ $document->expiry_date?->format('Y-m-d') }}
                                    </td>
                                    <td class="px-6 py-4">
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $document->status === 'valid' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                            {{ $document->status }}
                                        </span>
                                        @if ($document->trashed())
                                            <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-200 text-gray-800">
                                                {{ __('Deleted') }}
                                            </span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 text-right">
                                        @if ($document->trashed())
                                            <button wire:click="restoreDocument({{ $document->id }})" wire:confirm="{{ __('Are you sure you want to restore this document?') }}" class="bg-green-500 hover:bg-green-700 text-white font-bold py-1 px-3 rounded">{{ __('Restore') }}</button>
                                            <button wire:click="forceDeleteDocument({{ $document->id }})" wire:confirm="{{ __('Are you sure you want to permanently delete this document? This action cannot be undone.') }}" class="bg-red-700 hover:bg-red-900 text-white font-bold py-1 px-3 rounded ml-2">{{ __('Force Delete') }}</button>
                                        @else
                                            <button wire:click="editDocument({{ $document->id }})" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-1 px-3 rounded">{{ __('Edit') }}</button>
                                            <button wire:click="deleteDocument({{ $document->id }})" wire:confirm="{{ __('Are you sure you want to delete this document?') }}" class="bg-red-500 hover:bg-red-700 text-white font-bold py-1 px-3 rounded ml-2">{{ __('Delete') }}</button>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr class="bg-white border-b">
                                    <td colspan="5" class="px-6 py-4 text-center text-gray-500">
                                        {{ __('No documents found for this vehicle.') }}
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Maintenance Management Modal -->
    <div
        x-data="{ show: false }"
        x-cloak
        x-on:open-maintenance-management-modal.window="show = true"
        x-on:close-maintenance-management-modal.window="show = false"
        x-on:keydown.escape.window="show = false"
        x-show="show"
        class="fixed inset-0 overflow-y-auto px-4 py-6 sm:px-0 z-50"
    >
        <div
            x-show="show"
            class="fixed inset-0 transform transition-all"
            x-on:click="$dispatch('close-maintenance-management-modal')"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
        >
            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
        </div>

        <div
            x-show="show"
            class="mb-6 bg-white rounded-lg overflow-hidden shadow-xl transform transition-all sm:w-full sm:max-w-5xl sm:mx-auto"
            x-transition:enter="ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave="ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
        >
            @if ($this->currentVehicleForMaintenance->id)
                <form wire:submit.prevent="saveMaintenance" wire:key="maintenance-form-{{ $isEditingMaintenance ? $maintenanceForm->maintenanceRecord->id : 'new' }}">
                    <div class="px-6 py-4">
                        <div class="text-lg">
                            {{ $isEditingMaintenance ? __('Edit Maintenance Record') : __('Create Maintenance Record') }}
                            ({{ __('for') }} {{ $this->currentVehicleForMaintenance->name }})
                        </div>

                        <div class="mt-6 space-y-4">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="maintenance_type_id" class="block text-sm font-medium text-gray-700">{{ __('Maintenance Type') }}</label>
                                    <select wire:model="maintenanceForm.maintenance_type_id" id="maintenance_type_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                        <option value="">{{ __('Select Maintenance Type') }}</option>
                                        @foreach ($maintenanceTypes as $type)
                                            <option value="{{ $type->id }}">{{ $type->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('maintenanceForm.maintenance_type_id') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                </div>
                                <div>
                                    <label for="performed_by" class="block text-sm font-medium text-gray-700">{{ __('Performed By') }}</label>
                                    <input wire:model="maintenanceForm.performed_by" id="performed_by" type="text" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                    @error('maintenanceForm.performed_by') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                </div>
                            </div>

                            <div>
                                <label for="description" class="block text-sm font-medium text-gray-700">{{ __('Description') }}</label>
                                <textarea wire:model="maintenanceForm.description" id="description" rows="2" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></textarea>
                                @error('maintenanceForm.description') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                                <div>
                                    <label for="date" class="block text-sm font-medium text-gray-700">{{ __('Date') }}</label>
                                    <input wire:model="maintenanceForm.date" id="date" type="date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                    @error('maintenanceForm.date') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                </div>
                                <div>
                                    <label for="cost" class="block text-sm font-medium text-gray-700">{{ __('Cost') }}</label>
                                    <input wire:model="maintenanceForm.cost" id="cost" type="number" step="0.01" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                    @error('maintenanceForm.cost') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                </div>
                                <div>
                                    <label for="odometer_reading" class="block text-sm font-medium text-gray-700">{{ __('Odometer') }}</label>
                                    <input wire:model="maintenanceForm.odometer_reading" id="odometer_reading" type="number" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                    @error('maintenanceForm.odometer_reading') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                </div>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                                <div>
                                    <label for="next_service_date" class="block text-sm font-medium text-gray-700">{{ __('Next Service Date') }}</label>
                                    <input wire:model="maintenanceForm.next_service_date" id="next_service_date" type="date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                    @error('maintenanceForm.next_service_date') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                </div>
                                <div>
                                    <label for="next_service_odometer" class="block text-sm font-medium text-gray-700">{{ __('Next Service Odometer') }}</label>
                                    <input wire:model="maintenanceForm.next_service_odometer" id="next_service_odometer" type="number" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" placeholder="e.g. 150000">
                                    @error('maintenanceForm.next_service_odometer') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                                </div>
                            </div>

                            <div>
                                <label for="notes" class="block text-sm font-medium text-gray-700">{{ __('Notes') }}</label>
                                <textarea wire:model="maintenanceForm.notes" id="notes" rows="2" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></textarea>
                                @error('maintenanceForm.notes') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                    </div>

                    <div class="bg-gray-100 px-6 py-4 flex justify-end">
                        <button type="button" x-on:click="$dispatch('close-maintenance-management-modal')" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded mr-2">
                            {{ __('Cancel') }}
                        </button>
                        <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                            {{ __('Save') }}
                        </button>
                    </div>
                </form>

                <div class="p-6 text-gray-900 border-t mt-4">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-medium text-gray-900">{{ __('Maintenance History') }}</h3>
                        <button wire:click="createMaintenance" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                            <i class="fa-solid fa-plus"></i> {{ __('Add Record') }}
                        </button>
                    </div>
                    <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
                        
                        <table class="w-full text-sm text-left text-gray-500">
                            <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                                <tr>
                                    <th scope="col" class="px-6 py-3">{{ __('Type') }}</th>
                                    <th scope="col" class="px-6 py-3">{{ __('Description') }}</th>
                                    <th scope="col" class="px-6 py-3">{{ __('Date') }}</th>
                                    <th scope="col" class="px-6 py-3">{{ __('Cost') }}</th>
                                    <th scope="col" class="px-6 py-3"><span class="sr-only">{{ __('Actions') }}</span></th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($vehicleMaintenanceRecords as $record)
                                    <tr wire:key="maintenance-record-{{ $record->id }}" class="bg-white border-b hover:bg-gray-50 {{ $record->trashed() ? 'bg-red-50/50' : '' }}">
                                        <td class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">{{ $record->maintenanceType->name ?? __('N/A') }}</td>
                                        <td class="px-6 py-4 text-gray-500">{{ Str::limit($record->description, 40) }}</td>
                                        <td class="px-6 py-4 text-gray-500">{{ $record->date->format('Y-m-d') }}</td>
                                        <td class="px-6 py-4 text-gray-500">{{ Number::format($record->cost, precision: 2) ?? __('N/A')}}</td>
                                        <td class="px-6 py-4 text-right">
                                            @if ($record->trashed())
                                                <button wire:click="restoreMaintenanceRecord({{ $record->id }})" wire:confirm="{{ __('Are you sure?') }}" class="bg-green-500 hover:bg-green-700 text-white font-bold py-1 px-3 rounded" aria-label="{{ __('Restore') }}"><i class="fa-solid fa-undo"></i></button>
                                                <button wire:click="forceDeleteMaintenanceRecord({{ $record->id }})" wire:confirm="{{ __('Are you sure you want to permanently delete this record?') }}" class="bg-red-700 hover:bg-red-900 text-white font-bold py-1 px-3 rounded ml-2" aria-label="{{ __('Force Delete') }}"><i class="fa-solid fa-times-circle"></i></button>
                                            @else
                                                <button wire:click="editMaintenance({{ $record->id }})" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-1 px-3 rounded" aria-label="{{ __('Edit') }}"><i class="fa-solid fa-edit"></i></button>
                                                <button wire:click="deleteMaintenanceRecord({{ $record->id }})" wire:confirm="{{ __('Are you sure?') }}" class="bg-red-500 hover:bg-red-700 text-white font-bold py-1 px-3 rounded ml-2" aria-label="{{ __('Delete') }}"><i class="fa-solid fa-trash"></i></button>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr class="bg-white border-b">
                                        <td colspan="5" class="px-6 py-4 text-center text-gray-500">
                                            {{ __('No maintenance records found.') }}
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>