<div>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Gestión de Viajes') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center space-x-4">
                        <!-- Filtro por Conductor -->
                        <div>
                            <x-input-label for="filter_driver_id" :value="__('Conductor')" />
                            <select wire:model.live="filter_driver_id" id="filter_driver_id" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                                <option value="">{{ __('Todos') }}</option>
                                @foreach($employees as $employee)
                                    <option value="{{ $employee->id }}">{{ $employee->full_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <!-- Filtro por Fecha -->
                        <div>
                            <x-input-label for="filter_date" :value="__('Fecha de Viaje')" />
                            <x-text-input wire:model.live="filter_date" id="filter_date" class="block mt-1 w-full" type="date" />
                        </div>
                    </div>
                    <button wire:click="create" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded" aria-label="{{ __('Crear Nuevo Viaje') }}">
                        <i class="fa-solid fa-plus"></i>
                    </button>
                </div>

                <!-- Tabla de Viajes -->
                <div class="relative overflow-x-auto shadow-md sm:rounded-lg">
                    <table class="w-full text-sm text-left text-gray-500">
                        <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3 cursor-pointer" wire:click="sortBy('origin')">
                                    {{ __('Origen') }}
                                    @if($sortField === 'origin')
                                        <i class="fa-solid fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                    @endif
                                </th>
                                <th scope="col" class="px-6 py-3 cursor-pointer" wire:click="sortBy('destination')">
                                    {{ __('Destino') }}
                                    @if($sortField === 'destination')
                                        <i class="fa-solid fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                    @endif
                                </th>
                                <th scope="col" class="px-6 py-3">{{ __('Conductor') }}</th>
                                <th scope="col" class="px-6 py-3">{{ __('Tractocamión') }}</th>
                                <th scope="col" class="px-6 py-3 cursor-pointer" wire:click="sortBy('start_date')">
                                    {{ __('Fecha de Inicio') }}
                                    @if($sortField === 'start_date')
                                        <i class="fa-solid fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                    @endif
                                </th>
                                <th scope="col" class="px-6 py-3">{{ __('Estado') }}</th>
                                <th scope="col" class="px-6 py-3"><span class="sr-only">{{ __('Acciones') }}</span></th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($trips as $trip)
                                <tr wire:key="{{ $trip->id }}" class="bg-white border-b hover:bg-gray-50">
                                    <td class="px-6 py-4">{{ $trip->origin }}</td>
                                    <td class="px-6 py-4">{{ $trip->destination }}</td>
                                    <td class="px-6 py-4">{{ $trip->driver->full_name ?? 'N/A' }}</td>
                                    <td class="px-6 py-4">{{ $trip->tractor->name ?? 'N/A' }}</td>
                                    <td class="px-6 py-4">{{ $trip->start_date->format('d/m/Y H:i') }}</td>
                                    <td class="px-6 py-4">
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                            @switch($trip->status)
                                                @case('pending') bg-yellow-100 text-yellow-800 @break
                                                @case('in_progress') bg-blue-100 text-blue-800 @break
                                                @case('completed') bg-green-100 text-green-800 @break
                                                @case('cancelled') bg-red-100 text-red-800 @break
                                            @endswitch
                                        ">
                                            {{ __($trip->status) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 text-right whitespace-nowrap">
                                        <button wire:click="edit({{ $trip->id }})" class="bg-yellow-500 hover:bg-yellow-700 text-white font-bold py-1 px-2 rounded" aria-label="{{ __('Editar') }}">
                                            <i class="fa-solid fa-pen-to-square"></i>
                                        </button>
                                        <button wire:click="delete({{ $trip->id }})" wire:confirm="{{ __('¿Está seguro de que desea eliminar este viaje?') }}" class="bg-red-500 hover:bg-red-700 text-white font-bold py-1 px-2 rounded ml-2" aria-label="{{ __('Eliminar') }}">
                                            <i class="fa-solid fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            @empty
                                <tr class="bg-white border-b">
                                    <td colspan="7" class="px-6 py-4 text-center text-gray-500">
                                        {{ __('No se encontraron viajes.') }}
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="mt-4">
                    {{ $trips->links() }}
                </div>

            </div>
        </div>
    </div>

    {{-- Modal Form --}}
    <div x-data="{ show: false }" x-cloak x-on:open-modal.window="show = true" x-on:close-modal.window="show = false" x-on:keydown.escape.window="show = false" x-show="show" class="fixed inset-0 overflow-y-auto px-4 py-6 sm:px-0 z-50">
        <div x-show="show" class="fixed inset-0 transform transition-all" x-on:click="show = false" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0">
            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
        </div>

        <div x-show="show" class="mb-6 bg-white rounded-lg overflow-hidden shadow-xl transform transition-all sm:w-full sm:max-w-3xl sm:mx-auto" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95">
            <form wire:submit.prevent="save">
                <div class="p-6">
                    <h2 class="text-lg font-medium text-gray-900">
                        {{ $isEditing ? 'Editar Viaje' : 'Crear Nuevo Viaje' }}
                    </h2>

                    <div class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-4">
                        {{-- Driver --}}
                        <div>
                            <x-input-label for="driver_id" :value="__('Conductor')" />
                            <select id="driver_id" wire:model="driver_id" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                                <option value="">{{ __('Seleccione un conductor') }}</option>
                                @foreach ($employees as $employee)
                                    <option value="{{ $employee->id }}">{{ $employee->full_name }}</option>
                                @endforeach
                            </select>
                            <x-input-error :messages="$errors->get('driver_id')" class="mt-2" />
                        </div>

                        {{-- Tractor --}}
                        <div>
                            <x-input-label for="tractor_id" :value="__('Tractocamión')" />
                            <select id="tractor_id" wire:model="tractor_id" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                                <option value="">{{ __('Seleccione un tractocamión') }}</option>
                                @foreach ($tractors as $tractor)
                                    <option value="{{ $tractor->id }}">{{ $tractor->name }} ({{ $tractor->plate_number }})</option>
                                @endforeach
                            </select>
                            <x-input-error :messages="$errors->get('tractor_id')" class="mt-2" />
                        </div>

                        {{-- Trailer --}}
                        <div>
                            <x-input-label for="trailer_id" :value="__('Remolque (Opcional)')" />
                            <select id="trailer_id" wire:model="trailer_id" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                                <option value="">{{ __('Seleccione un remolque') }}</option>
                                @foreach ($trailers as $trailer)
                                    <option value="{{ $trailer->id }}">{{ $trailer->name }} ({{ $trailer->plate_number }})</option>
                                @endforeach
                            </select>
                            <x-input-error :messages="$errors->get('trailer_id')" class="mt-2" />
                        </div>

                        {{-- Status --}}
                        <div>
                            <x-input-label for="status" :value="__('Estado')" />
                            <select id="status" wire:model="status" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                                <option value="pending">{{ __('Pendiente') }}</option>
                                <option value="in_progress">{{ __('En Progreso') }}</option>
                                <option value="completed">{{ __('Completado') }}</option>
                                <option value="cancelled">{{ __('Cancelado') }}</option>
                            </select>
                            <x-input-error :messages="$errors->get('status')" class="mt-2" />
                        </div>

                        {{-- Start Date --}}
                        <div>
                            <x-input-label for="start_date" :value="__('Fecha de Inicio')" />
                            <x-text-input id="start_date" class="block mt-1 w-full" type="datetime-local" wire:model="start_date" />
                            <x-input-error :messages="$errors->get('start_date')" class="mt-2" />
                        </div>

                        {{-- End Date --}}
                        <div>
                            <x-input-label for="end_date" :value="__('Fecha de Fin')" />
                            <x-text-input id="end_date" class="block mt-1 w-full" type="datetime-local" wire:model="end_date" />
                            <x-input-error :messages="$errors->get('end_date')" class="mt-2" />
                        </div>

                        {{-- Start Odometer --}}
                        <div>
                            <x-input-label for="start_odometer_tractor" :value="__('Odómetro Inicial (Tracto)')" />
                            <x-text-input id="start_odometer_tractor" class="block mt-1 w-full" type="number" wire:model="start_odometer_tractor" />
                            <x-input-error :messages="$errors->get('start_odometer_tractor')" class="mt-2" />
                        </div>

                        {{-- End Odometer --}}
                        <div>
                            <x-input-label for="end_odometer_tractor" :value="__('Odómetro Final (Tracto)')" />
                            <x-text-input id="end_odometer_tractor" class="block mt-1 w-full" type="number" wire:model="end_odometer_tractor" />
                            <x-input-error :messages="$errors->get('end_odometer_tractor')" class="mt-2" />
                        </div>

                        {{-- Origin --}}
                        <div class="md:col-span-2">
                            <x-input-label for="origin" :value="__('Origen')" />
                            <x-text-input id="origin" class="block mt-1 w-full" type="text" wire:model="origin" />
                            <x-input-error :messages="$errors->get('origin')" class="mt-2" />
                        </div>

                        {{-- Destination --}}
                        <div class="md:col-span-2">
                            <x-input-label for="destination" :value="__('Destino')" />
                            <x-text-input id="destination" class="block mt-1 w-full" type="text" wire:model="destination" />
                            <x-input-error :messages="$errors->get('destination')" class="mt-2" />
                        </div>

                        {{-- Notes --}}
                        <div class="md:col-span-2">
                            <x-input-label for="notes" :value="__('Notas')" />
                            <textarea id="notes" wire:model="notes" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3"></textarea>
                            <x-input-error :messages="$errors->get('notes')" class="mt-2" />
                        </div>
                    </div>
                </div>

                <div class="bg-gray-100 px-6 py-4 flex justify-end">
                    <button type="button" x-on:click="show = false" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded mr-2">
                        {{ __('Cancelar') }}
                    </button>
                    <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                        {{ $isEditing ? 'Guardar Cambios' : 'Crear Viaje' }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
