<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trips', function (Blueprint $table) {
            $table->id();
            $table->foreignId('driver_id')->constrained('employees')->onDelete('restrict');
            $table->foreignId('tractor_id')->constrained('vehicles')->onDelete('restrict');
            $table->foreignId('trailer_id')->nullable()->constrained('vehicles')->onDelete('restrict'); // Trailer can be nullable
            $table->dateTime('start_date');
            $table->dateTime('end_date')->nullable();
            $table->integer('start_odometer_tractor');
            $table->integer('end_odometer_tractor')->nullable();
            $table->string('origin');
            $table->string('destination');
            $table->string('status')->default('pending'); // e.g., 'pending', 'in_progress', 'completed', 'cancelled'
            $table->text('notes')->nullable();

            // Auditable columns
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('deleted_by')->nullable()->constrained('users')->onDelete('set null');
            $table->softDeletes(); // For SoftDeletes trait

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trips');
    }
};
