<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('maintenance_records', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vehicle_id')->constrained('vehicles')->onDelete('cascade');
            $table->foreignId('maintenance_type_id')->constrained('maintenance_types')->onDelete('restrict');
            $table->text('description');
            $table->date('date');
            $table->decimal('cost', 10, 2)->nullable();
            $table->string('performed_by')->nullable(); // e.g., "Taller X", "Mecánico Juan"
            $table->text('notes')->nullable();
            $table->date('next_service_date')->nullable(); // For preventive maintenance scheduling
            $table->integer('odometer_reading')->nullable(); // Odometer reading at the time of maintenance

            // Auditable and SoftDeletes
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('deleted_by')->nullable()->constrained('users')->onDelete('set null');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('maintenance_records');
    }
};
