<?php

use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('documents', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g., "Licencia de Conducir", "Curso de Mercancías Peligrosas"
            $table->text('description')->nullable();
            $table->string('file_path'); // Path to the stored file
            $table->date('issue_date')->nullable();
            $table->date('expiry_date')->nullable(); // CRITICAL for notifications
            $table->string('status')->default('valid'); // e.g., 'valid', 'expired', 'pending_review'

            // Polymorphic relation
            $table->unsignedBigInteger('documentable_id');
            $table->string('documentable_type');
            $table->index(['documentable_id', 'documentable_type']);

            // Auditing fields
            $table->foreignIdFor(User::class, 'created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignIdFor(User::class, 'updated_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignIdFor(User::class, 'deleted_by')->nullable()->constrained('users')->onDelete('set null');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('documents');
    }
};
