<?php

use App\Models\Vehicle;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tractor_truck_details', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Vehicle::class)->unique()->constrained('vehicles')->onDelete('cascade');
            $table->decimal('towing_capacity_tons', 8, 2)->nullable();
            $table->string('engine_specs')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tractor_truck_details');
    }
};
