<?php

namespace App\Models;

use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Trip extends Model
{
    use HasFactory, SoftDeletes, Auditable;

    protected $fillable = [
        'driver_id',
        'tractor_id',
        'trailer_id',
        'start_date',
        'end_date',
        'start_odometer_tractor',
        'end_odometer_tractor',
        'origin',
        'destination',
        'status',
        'notes',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'start_date' => 'datetime',
        'end_date' => 'datetime',
    ];

    public function driver()
    {
        return $this->belongsTo(Employee::class, 'driver_id');
    }

    public function tractor()
    {
        return $this->belongsTo(Vehicle::class, 'tractor_id');
    }

    public function trailer()
    {
        return $this->belongsTo(Vehicle::class, 'trailer_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function editor()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function destroyer()
    {
        return $this->belongsTo(User::class, 'deleted_by');
    }
}