<?php

namespace App\Models;

use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MaintenanceRecord extends Model
{
    use Auditable, HasFactory, SoftDeletes;

    protected $fillable = [
        'vehicle_id',
        'maintenance_type_id',
        'description',
        'date',
        'cost',
        'performed_by',
        'notes',
        'next_service_date',
        'next_service_odometer',
        'odometer_reading',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'date' => 'date',
        'next_service_date' => 'date',
    ];

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function maintenanceType()
    {
        return $this->belongsTo(MaintenanceType::class);
    }
}
