<?php

namespace App\Livewire\Shipment;

use App\Models\Shipment;
use App\Models\Trip;
use App\Models\Customer;
use Livewire\Component;
use LivewireUI\Modal\ModalComponent;

class Form extends ModalComponent
{
    public Shipment $shipment;
    public $trip_id;
    public $customer_id;
    public $description;
    public $weight_tons;
    public $volume_m3;
    public $pickup_address;
    public $pickup_latitude;
    public $pickup_longitude;
    public $delivery_address;
    public $delivery_latitude;
    public $delivery_longitude;
    public $status = 'pending';
    public $notes;

    public $trips;
    public $customers;

    protected $rules = [
        'trip_id' => 'nullable|exists:trips,id',
        'customer_id' => 'required|exists:customers,id',
        'description' => 'required|string|max:255',
        'weight_tons' => 'required|numeric|min:0',
        'volume_m3' => 'nullable|numeric|min:0',
        'pickup_address' => 'required|string|max:255',
        'pickup_latitude' => 'required|numeric',
        'pickup_longitude' => 'required|numeric',
        'delivery_address' => 'required|string|max:255',
        'delivery_latitude' => 'required|numeric',
        'delivery_longitude' => 'required|numeric',
        'status' => 'required|string|in:pending,in_transit,delivered,damaged',
        'notes' => 'nullable|string|max:1000',
    ];

    public function mount(Shipment $shipment = null)
    {
        $this->shipment = $shipment ?? new Shipment();

        if ($this->shipment->exists) {
            $this->trip_id = $this->shipment->trip_id;
            $this->customer_id = $this->shipment->customer_id;
            $this->description = $this->shipment->description;
            $this->weight_tons = $this->shipment->weight_tons;
            $this->volume_m3 = $this->shipment->volume_m3;
            $this->pickup_address = $this->shipment->pickup_address;
            $this->pickup_latitude = $this->shipment->pickup_latitude;
            $this->pickup_longitude = $this->shipment->pickup_longitude;
            $this->delivery_address = $this->shipment->delivery_address;
            $this->delivery_latitude = $this->shipment->delivery_latitude;
            $this->delivery_longitude = $this->shipment->delivery_longitude;
            $this->status = $this->shipment->status;
            $this->notes = $this->shipment->notes;
        }

        $this->trips = Trip::all();
        $this->customers = Customer::all();
    }

    public function save()
    {
        $this->validate();

        $this->shipment->fill([
            'trip_id' => $this->trip_id,
            'customer_id' => $this->customer_id,
            'description' => $this->description,
            'weight_tons' => $this->weight_tons,
            'volume_m3' => $this->volume_m3,
            'pickup_address' => $this->pickup_address,
            'pickup_latitude' => $this->pickup_latitude,
            'pickup_longitude' => $this->pickup_longitude,
            'delivery_address' => $this->delivery_address,
            'delivery_latitude' => $this->delivery_latitude,
            'delivery_longitude' => $this->delivery_longitude,
            'status' => $this->status,
            'notes' => $this->notes,
        ])->save();

        $this->dispatch('shipment-saved');
        $this->closeModalWithEvents([
            'pg:eventRefresh' // Refresh Livewire tables
        ]);
        session()->flash('message', 'Shipment saved successfully.');
    }

    public function render()
    {
        return view('livewire.shipment.form');
    }
}