<?php

namespace App\Livewire\Forms;

use App\Models\Employee;
use Illuminate\Validation\Rule as ValidationRule;
use Livewire\Form;

class EmployeeForm extends Form
{
    public ?Employee $employee = null; // Explicitly initialize to null

    public $first_name = '';

    public $last_name = '';

    public $document_number = '';

    public $email = '';

    public $phone_number = '';

    public $address = '';

    public $hire_date = '';

    public $status = 'active';

    public $employee_type = 'driver';

    public $user_id = null;

    public function setEmployee(Employee $employee)
    {
        $this->employee = $employee;
        $this->first_name = $employee->first_name;
        $this->last_name = $employee->last_name;
        $this->document_number = $employee->document_number;
        $this->email = $employee->email;
        $this->phone_number = $employee->phone_number;
        $this->address = $employee->address;
        $this->hire_date = $employee->hire_date;
        $this->status = $employee->status;
        $this->employee_type = $employee->employee_type;
        $this->user_id = $employee->user_id;
    }

    public function store()
    {
        $validated = $this->validate([
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'document_number' => ['required', 'string', ValidationRule::unique('employees', 'document_number')],
            'email' => ['required', 'email', ValidationRule::unique('employees', 'email')],
            'phone_number' => 'nullable|string|max:255',
            'address' => 'nullable|string',
            'hire_date' => 'required|date',
            'status' => 'required|in:active,on_leave,terminated',
            'employee_type' => 'required|in:driver,administrative',
            'user_id' => 'nullable|exists:users,id',
        ]);

        Employee::create($validated);
    }

    public function update()
    {
        $validated = $this->validate([
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'document_number' => ['required', 'string', ValidationRule::unique('employees', 'document_number')->ignore($this->employee->id)],
            'email' => ['required', 'email', ValidationRule::unique('employees', 'email')->ignore($this->employee->id)],
            'phone_number' => 'nullable|string|max:255',
            'address' => 'nullable|string',
            'hire_date' => 'required|date',
            'status' => 'required|in:active,on_leave,terminated',
            'employee_type' => 'required|in:driver,administrative',
            'user_id' => 'nullable|exists:users,id',
        ]);

        $this->employee->update($validated);
    }
}
