<?php

namespace App\Livewire;

use App\Models\Document; // Import the Document model
use Livewire\Component;

class ExpiringDocumentsWidget extends Component
{
    public $expiringDocuments;

    public int $daysThreshold; // Configurable days threshold

    public function mount()
    {
        $this->daysThreshold = (int) config('documents.expiry_threshold_days');
        $this->loadExpiringDocuments();
    }

    public function loadExpiringDocuments()
    {
        $this->expiringDocuments = Document::with('documentable')
            ->where('expiry_date', '!=', null)
            ->where('expiry_date', '<=', now()->addDays($this->daysThreshold))
            ->where('expiry_date', '>=', now())
            ->where('status', 'valid')
            ->whereHas('documentable', function ($query) {
                $query->whereNull('deleted_at');
            })
            ->orderBy('expiry_date')
            ->get();
    }

    public function render()
    {
        return view('livewire.expiring-documents-widget');
    }
}
